import requests
from xldpodman import getBaseURL
import json

portmappingArray = []

volumemappingArray = []

podnetworks = {}

networks = {}

for network in deployed.podnetwork:
    static_ips = [[]]
    static_mac = []
    aliases = [] #String

    if network.aliases:
        for alias in network.aliases:
            aliases.append(alias)

    if network.staticIps:
        new_index = 0
        for staticIps in network.staticIps:
            static_ips[new_index].append(staticIps)
            new_index += 1

    if network.staticMac:
        new_index_mac = 0
        for staticMac in network.staticMac:
            static_mac.append(staticMac)
            new_index_mac += 1
    property = {
        'interface_name':network.interfaceName,
        'static_ips': static_ips,
        'static_mac': static_mac,
        'aliases':aliases
    }
    networks[network.propertyName] =  property
networkJson = {}
if networks != {}:
    networkJson = {'Networks':networks}

for portmappings in deployed.portmappings:
    config = {
        'container_port': portmappings.containerPort,
        'host_ip': portmappings.hostIp,
        'host_port': portmappings.hostPort,
        'protocol': portmappings.protocol,
        'range': portmappings.range
    }
    portmappingArray.append(config)

for volmappings in deployed.volumemappings:
    volconfig = {
        'Dest': volmappings.dest,
        'Name': volmappings.volumename,
        'Options': volmappings.options
    }
    volumemappingArray.append(volconfig)

userns = {
    'nsmode' : deployed.usernsNsmode,
    'value' : deployed.usernsValue
}

netns = {
    'nsmode' : deployed.netnsNsmode,
    'value' : deployed.netnsValue
}

networkOptions = {}

for key, value in deployed.networkOptions.items():
    valueARray = [value]
    networkOptions[key] = valueARray

pod_name = deployed.PodName or deployed.name

podDict={'cgroup_parent': deployed.cgroupParent,
         'name': pod_name,
         'infra_image': deployed.infra_image,
         'labels': deployed.labels,
         'hostname': deployed.hostname,
         'cpu_period': deployed.cpu_period,
         'cpu_quota': deployed.cpu_quota,
         'infra_command': deployed.infra_command,
         'no_infra': deployed.no_infra,
         'no_manage_hosts': deployed.no_manage_hosts,
         'pod_create_command': deployed.pod_create_command,
         'pod_devices': deployed.pod_devices,
         'portmappings': portmappingArray,
         'volumes': volumemappingArray,
         'userns': userns,
         'netns': netns,
         'network_options': networkOptions
         }
if networkJson != {}:
    podDict['Networks'] = networkJson

print "Creating Pod", pod_name
url = getBaseURL(deployed.container)
url = url + "/libpod/pods/create"
app_json = json.dumps(podDict)
response = requests.post(url = url, data = app_json)
responseLoad = response.json()
if not response.ok:
    print "Pod Creation Error with with cause : "+ responseLoad['cause']
    raise Exception("Pod Creation Error with with message : "+ responseLoad['message'])
else:
    deployed.PodId = responseLoad['Id']
    print "Pod has been created with ID", deployed.PodId
    if(deployed.start_pod):
        print "STARTED"
        newurl = getBaseURL(deployed.container)
        newurl = newurl + "/libpod/pods/"+deployed.PodId+"/start"
        responseres = requests.post(url = newurl)
        if not responseres.ok:
            responsestart = responseres.json()
            if(responseres.status_code == 409):
                print "Pod Starting Error with with cause : "+ responsestart['Errs'][0]
                raise Exception("Pod Starting Error with with message : "+ responsestart['Errs'][0])
            else:
                print "Pod Starting Error with with cause : "+ responsestart['cause']
                raise Exception("Pod Starting Error with with message : "+ responsestart['message'])
        else:
            print "Pod has been Started with ID", deployed.PodId

