#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

#
#from xldpodman import connect_to_docker
#dkr = connect_to_docker(deployed.container)

import requests
from xldpodman import getBaseURL
import json

containerImageVolumes = []
for imageVolume in deployed.containerImageVolume:
    containerImageVolumesBind = {
        'Destination': imageVolume.Destination,
        'Source': imageVolume.Source,
        'ReadWrite': imageVolume.ReadWrite
    }
    containerImageVolumes.append(containerImageVolumesBind)

containerVolumes = []
for volume in deployed.containerVolumes:
    containerVolumesBind = {
        'Name': volume.Name,
        'Dest': volume.Dest
    }
    if volume.Options:
        containerVolumesBind['Options'] = volume.Options
    containerVolumes.append(containerVolumesBind)

ports = []
for port_binding in deployed.portBindings:
    containerPortBind = {
        'container_port': port_binding.containerPort,
        'host_port': port_binding.hostPort,
        'host_ip': port_binding.hostIp,
        'protocol': port_binding.protocol
    }
    if port_binding.range:
        containerPortBind['range'] = port_binding.range
    ports.append(containerPortBind)

restart_policy = None
if deployed.restartPolicyName and deployed.restartPolicyName != 'none':
    restart_policy = {'Name': deployed.restartPolicyName, 'MaximumRetryCount': deployed.restartPolicyMaximumRetryCount}

network_mode = "bridge"
if deployed.networks:
    network_mode = deployed.networks[0]

container_name = deployed.containerName or deployed.name
print "Creating container", container_name, "from image", deployed.image

host_config={'dns_opt': deployed.dnsOptions,
                'links': deployed.links,
                'mem_limit': deployed.memoryLimit,
                'network_mode': network_mode,
                'pid_mode': deployed.pidMode,
                'privileged': deployed.privileged,
                'publish_all_ports': deployed.publishAllPorts,
                'restart_policy': restart_policy}

containerDict={'name': container_name,
                  'image': deployed.image,
                  'command': deployed.command,
                  'domainname': deployed.domainname,
                  'detach': True,
                  'entrypoint': deployed.entrypoint,
                  'env': deployed.environment,
                  'host_config': host_config,
                  'hostname': deployed.hostname,
                  'labels': deployed.labels,
                  'portmappings': ports,
                  'tty': deployed.tty,
                  'volumes': containerVolumes,
                  'image_volumes': containerImageVolumes,
                  'work_dir': deployed.workDir,
                  'timezone': deployed.timeZone}

if deployed.init is not None:
    containerDict['init'] = (deployed.init.lower() == 'true')

print ("Creating container", container_name, "from image", deployed.image)
url = getBaseURL(deployed.container)
url = url + "/libpod/containers/create"
app_json = json.dumps(containerDict)
response = requests.post(url = url, data = app_json)
responseLoad = response.json()
if not response.ok:
    print "Container Creation Error with with cause : "+ responseLoad['cause']
    raise Exception("Container Creation Error with with message : "+ responseLoad['message'])
else:
    deployed.containerId = responseLoad['Id']
    print "Container has been created with ID", deployed.containerId


