#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

def stop_start_podman_container(deployed):
    if deployed is None:
        return

    if deployed.type == "podman.DeployedFolder":
        context.addStep(steps.jython(
            description="Put folder {} on {} in container {} on {}".format(deployed.name, deployed.targetPath, deployed.targetContainer, deployed.container.name),
            order=71,
            script="xldpodman/put_archive.py",
            jython_context={'deployed': deployed}
        ))

    if deployed.type == "podman.DeployedFile":
        context.addStep(steps.jython(
            description="Copy file {} on {} in container {} on {}".format(deployed.name, deployed.targetPath, deployed.targetContainer, deployed.container.name),
            order=71,
            script="xldpodman/copy_file.py",
            jython_context={'deployed': deployed}
        ))


def get_files_folders(m_containers, noop_file_folder):
    candidates = []
    for delta_c in m_containers:
        for delta_f in noop_file_folder:
            container = delta_f.deployed
            container_name = delta_c.deployed.containerName or delta_c.deployed.name
            if container.targetContainer == container_name:
                candidates.append(container)

    return set(candidates)


modify_containers = filter(lambda delta: delta.operation == "MODIFY" and delta.deployedOrPrevious.type == "podman.Container", deltas.deltas)

noop_folder_file = filter(
    lambda delta: delta.operation == "NOOP" and (delta.deployedOrPrevious.type == "podman.DeployedFolder" or delta.deployedOrPrevious.type == "podman.DeployedFile"),
    deltas.deltas)

candidates = get_files_folders(modify_containers, noop_folder_file)

map(stop_start_podman_container, candidates)
