#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

#
from xldpodman import getBaseURL
import requests
import json

network_name = deployed.networkName or deployed.name

configArray = []

for config_binding in deployed.configBindings:
    config = {
        'AuxiliaryAddresses': config_binding.auxiliaryAddresses,
        'Gateway': config_binding.gateway,
        'Subnet': config_binding.subnet
    }
    configArray.append(config)

ConfigFrom = {
    'Network': deployed.configFromNetwork
}

IPAM = {
    'Config': configArray,
    'Driver': deployed.ipamDriver,
    'Options': deployed.ipamOptions
}

networkDict={   'Name': network_name,
                'Driver': deployed.driver,
                'Options': deployed.options,
                'Internal': deployed.internal,
                'EnableIPv6': deployed.ipv6Enabled,
                'Attachable': deployed.attachable,
                'ConfigOnly': deployed.configOnly,
                'CheckDuplicate': deployed.checkDuplicate,
                'Ingress': deployed.ingress,
                'ConfigFrom': ConfigFrom,
                'IPAM': IPAM,
                'Labels': deployed.labels,
                'ConfigFromNetwork': deployed.configFromNetwork,
                'Scope': deployed.scope
               }
urlnew = getBaseURL(deployed.container)
url = urlnew + "/networks/create"
app_json = json.dumps(networkDict)
response = requests.post(url = url, data = app_json)
response.raise_for_status()  # raises exception when not a 2xx response
responseLoad = response.json()
if not response.ok:
    print "Network Creation Error with with cause : "+ responseLoad['cause']
    raise Exception("Network Creation Error with with message : "+ responseLoad['message'])
else:
    deployed.networkId = responseLoad['Id']
    print "Network has been created with ID", deployed.networkId
