#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

#
#from xldpodman import connect_to_docker
#dkr = connect_to_docker(deployed.container)

import requests
from xldpodman import getBaseURL
import json

volumes = []
binds = {}
for volume_binding in deployed.volumeBindings:
    volume_name = volume_binding.volumeName or volume_binding.name
    mountpoint = volume_binding.mountpoint
    mode = 'ro' if volume_binding.readOnly else 'rw'
    volumes.append(mountpoint)
    binds[volume_name] = { 'bind': mountpoint, 'mode': mode }

ports = []
port_bindings = {}
for port_binding in deployed.portBindings:
    container_port = port_binding.containerPort
    host_port = port_binding.hostPort
    protocol = port_binding.protocol
    if protocol != 'tcp':
        ports.append((container_port, str(protocol)))
        port_bindings[str(container_port) + '/' + str(protocol)] = host_port
    else:
        ports.append(container_port)
        port_bindings[container_port] = host_port

restart_policy = None
if deployed.restartPolicyName and deployed.restartPolicyName != 'none':
    restart_policy = {'Name': deployed.restartPolicyName, 'MaximumRetryCount': deployed.restartPolicyMaximumRetryCount}

network_mode = "bridge"
if deployed.networks:
    network_mode = deployed.networks[0]

container_name = deployed.containerName or deployed.name
print "Creating container", container_name, "from image", deployed.image

host_config={'binds': binds,
                'dns_opt': deployed.dnsOptions,
                'links': deployed.links,
                'mem_limit': deployed.memoryLimit,
                'network_mode': network_mode,
                'pid_mode': deployed.pidMode,
                'port_bindings': port_bindings,
                'privileged': deployed.privileged,
                'publish_all_ports': deployed.publishAllPorts,
                'restart_policy': restart_policy}

containerDict={'name': container_name,
                  'image': deployed.image,
                  'command': deployed.command,
                  'domainname': deployed.domainname,
                  'detach': True,
                  'entrypoint': deployed.entrypoint,
                  'environment': deployed.environment,
                  'host_config': host_config,
                  'hostname': deployed.hostname,
                  'labels': deployed.labels,
                  'ports': ports,
                  'tty': deployed.tty,
                  'volumes': volumes,
                  'working_dir': deployed.workingDir}


print "Creating container", container_name, "from image", deployed.image
url = getBaseURL(deployed.container)
url = url + "/libpod/containers/create"
app_json = json.dumps(containerDict)
response = requests.post(url = url, data = app_json)
response.raise_for_status()  # raises exception when not a 2xx response
reponseLoad = response.json()
deployed.containerId = reponseLoad['Id']
print "Container has been created with ID", deployed.containerId
