#
# THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS
# FOR A PARTICULAR PURPOSE. THIS CODE AND INFORMATION ARE NOT SUPPORTED BY XEBIALABS.
#

import glob
from StringIO import StringIO
import sys

#XLDeploy connects to the admin server of the domain to which the managed server belongs to
#To create a partition we need to connect to the managed server directly
disconnect()

# Start main function
result = "-1"

print 'Processing [' + str(deployed.name) + ']'


# TODO: replace with wrapper function
old_stdout = sys.stdout
redirectedStdout = StringIO()
sys.stdout = redirectedStdout

# Align to the topology: Cluster has no host
if deployed.container.type == "wls.Cluster":
	target_container = deployed.container.servers[0]
else:
	target_container = deployed.container

# Replace missing address property for overthere.LocalHost type
if target_container.host.type == "overthere.LocalHost":
	target_address = "localhost"
else:
	target_address = target_container.host.address

managedServerUrl="t3://"+target_address+":"+str(target_container.port)

connect(deployed.container.domain.username, deployed.container.domain.password, managedServerUrl)

print 'Creating partition [' + deployed.partition + "] on [" + managedServerUrl + ']'

sca_createPartition(partitionName = deployed.partition)
sys.stdout = old_stdout
result_string = redirectedStdout.getvalue()
if 'Exception:' in result_string and 'already exists' in result_string:
	print 'Partition already exists, ignoring'

disconnect()

theurl=str(deployed.file)

jars=glob.glob(theurl+'/*.jar')

configplan=glob.glob(theurl+'/*.xml')

old_stdout = sys.stdout
redirectedStdout = StringIO()
sys.stdout = redirectedStdout

server_url="http://"+target_address+":"+str(target_container.port)

if configplan and len(configplan) > 0:
	for jar in jars:
		print 'Deploying [' + jar + '] with plan [' + str(configplan) + '] on [' + server_url + ']'
		if deployed.container.domain.version in ["WEBLOGIC_12"]:
			sca_deployComposite(server_url, jar, True, deployed.container.domain.username, deployed.container.domain.password, deployed.forcedefault == 'true', configplan[0], partition=deployed.partition, keepInstancesOnRedeploy=(deployed.keepInstancesOnRedeploy == 'true'))
		else:
			sca_deployComposite(server_url, jar, True, deployed.container.domain.username, deployed.container.domain.password, deployed.forcedefault == 'true', configplan[0], partition=deployed.partition)
else:
	for jar in jars:
		print 'Deploying [' + jar + '] on [' + server_url + ']'
		if deployed.container.domain.version in ["WEBLOGIC_12"]:
			sca_deployComposite(server_url, jar, True, deployed.container.domain.username, deployed.container.domain.password, deployed.forcedefault == 'true', partition=deployed.partition, keepInstancesOnRedeploy=(deployed.keepInstancesOnRedeploy == 'true'))
		else:
			sca_deployComposite(server_url, jar, True, deployed.container.domain.username, deployed.container.domain.password, deployed.forcedefault == 'true', partition=deployed.partition)

sys.stdout = old_stdout

result_string = redirectedStdout.getvalue()
print 'result'
print result_string
if '--->Deploying composite success.' in result_string:
	print 'ok'
	result = "0"
else:
	print 'error'

print "DEPLOYIT-DAEMON-EXIT-VALUE: " + result

# Restore connection to the admin server (Needed in case weblogic daemon is used.
if deployed.container.domain.hostname:
	admin_server_url=deployed.container.domain.protocol+"://"+deployed.container.domain.hostname+":"+str(deployed.container.domain.port)
else:
	admin_server_url=deployed.container.domain.protocol+"://"+deployed.container.domain.host.address+":"+str(deployed.container.domain.port)

connect(deployed.container.domain.username, deployed.container.domain.password, admin_server_url)

if result != "0":
	raise Exception('Deployment failed')