#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.deployment.deployment_helper import DeploymentHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper
from xld.kubernetes.service.exposedservices.service_steps_helper import ExposedServiceStepsHelper

DeploymentHelper.enrich_app_selectors(deployed)
container_helper = ContainerHelperFactory(deployed.container).create()
PodHelper.validate_pod(deployed_pod=deployed)
deployment_helper = DeploymentHelper()
deployment_helper.validate_deployment(deployed_deployment=deployed)
deployment_name = deployment_helper.get_deployment_name(deployed)

if deployment_helper.get_deployment_name(previousDeployed) != deployment_name:
    raise RuntimeError('Deployment name should not be modified.')

context.addStepWithCheckpoint(steps.jython(
    description="{0} Deployment {1} on {2}".format('Modify', deployment_name,
                                                   container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/deployment/modify_deployment.py",
    order=deployed.modifyOrder
), delta)

if deployed.minimumPodCount > 0:
    context.addStepWithCheckpoint(steps.jython(
        description="Wait for Deployment {0} to be in running state".format(deployment_name),
        script="xld/kubernetes/deployment/wait_for_deployment_ready_on_modify.py",
        order=deployed.modifyOrder + 1
    ), delta)

old_services = ExposedServiceStepsHelper.get_exposed_services(previousDeployed.containers,previousDeployed.labels,
                                                              deployment_helper.get_deployment_name(previousDeployed))
new_services = ExposedServiceStepsHelper.get_exposed_services(deployed.containers,deployed.labels,
                                                              deployment_helper.get_deployment_name(deployed))
ExposedServiceStepsHelper(context, steps).add_modify_steps(deployed, previousDeployed, old_services, new_services, delta)
