#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.deployment.deployment_helper import DeploymentHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper
from xld.kubernetes.service.exposedservices.service_steps_helper import ExposedServiceStepsHelper

DeploymentHelper.enrich_app_selectors(deployed)
container_helper = ContainerHelperFactory(deployed.container).create()
PodHelper.validate_pod(deployed_pod=deployed)
DeploymentHelper.validate_deployment(deployed_deployment=deployed)
deployment_name = DeploymentHelper().get_deployment_name(deployed)

context.addStepWithCheckpoint(steps.jython(
    description="{0} Deployment {1} on {2}".format('Create', deployment_name,
                                                   container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/deployment/create_deployment.py",
    order=deployed.createOrder
), delta)

if deployed.minimumPodCount > 0:
    context.addStepWithCheckpoint(steps.jython(
        description="Wait for Deployment {0} to be in running state".format(deployment_name),
        script="xld/kubernetes/deployment/wait_for_deployment_ready.py",
        order=deployed.createOrder + 1
    ), delta)

services = ExposedServiceStepsHelper.get_exposed_services(deployed.containers,deployed.labels,
                                                          DeploymentHelper().get_deployment_name(deployed))
ExposedServiceStepsHelper(context, steps).add_create_steps(deployed, services, delta)
