# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a client. By listing and beginning a watch from the returned resourceVersion, clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'metav1.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V1NetNamespace(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'api_version': 'str',
        'egress_i_ps': 'list[str]',
        'kind': 'str',
        'metadata': 'V1ObjectMeta',
        'netid': 'int',
        'netname': 'str'
    }

    attribute_map = {
        'api_version': 'apiVersion',
        'egress_i_ps': 'egressIPs',
        'kind': 'kind',
        'metadata': 'metadata',
        'netid': 'netid',
        'netname': 'netname'
    }

    def __init__(self, api_version=None, egress_i_ps=None, kind=None, metadata=None, netid=None, netname=None):
        """
        V1NetNamespace - a model defined in Swagger
        """

        self._api_version = None
        self._egress_i_ps = None
        self._kind = None
        self._metadata = None
        self._netid = None
        self._netname = None
        self.discriminator = None

        if api_version is not None:
          self.api_version = api_version
        if egress_i_ps is not None:
          self.egress_i_ps = egress_i_ps
        if kind is not None:
          self.kind = kind
        if metadata is not None:
          self.metadata = metadata
        self.netid = netid
        self.netname = netname

    @property
    def api_version(self):
        """
        Gets the api_version of this V1NetNamespace.
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources

        :return: The api_version of this V1NetNamespace.
        :rtype: str
        """
        return self._api_version

    @api_version.setter
    def api_version(self, api_version):
        """
        Sets the api_version of this V1NetNamespace.
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources

        :param api_version: The api_version of this V1NetNamespace.
        :type: str
        """

        self._api_version = api_version

    @property
    def egress_i_ps(self):
        """
        Gets the egress_i_ps of this V1NetNamespace.
        EgressIPs is a list of reserved IPs that will be used as the source for external traffic coming from pods in this namespace. (If empty, external traffic will be masqueraded to Node IPs.)

        :return: The egress_i_ps of this V1NetNamespace.
        :rtype: list[str]
        """
        return self._egress_i_ps

    @egress_i_ps.setter
    def egress_i_ps(self, egress_i_ps):
        """
        Sets the egress_i_ps of this V1NetNamespace.
        EgressIPs is a list of reserved IPs that will be used as the source for external traffic coming from pods in this namespace. (If empty, external traffic will be masqueraded to Node IPs.)

        :param egress_i_ps: The egress_i_ps of this V1NetNamespace.
        :type: list[str]
        """

        self._egress_i_ps = egress_i_ps

    @property
    def kind(self):
        """
        Gets the kind of this V1NetNamespace.
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :return: The kind of this V1NetNamespace.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """
        Sets the kind of this V1NetNamespace.
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :param kind: The kind of this V1NetNamespace.
        :type: str
        """

        self._kind = kind

    @property
    def metadata(self):
        """
        Gets the metadata of this V1NetNamespace.
        Standard object's metadata.

        :return: The metadata of this V1NetNamespace.
        :rtype: V1ObjectMeta
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this V1NetNamespace.
        Standard object's metadata.

        :param metadata: The metadata of this V1NetNamespace.
        :type: V1ObjectMeta
        """

        self._metadata = metadata

    @property
    def netid(self):
        """
        Gets the netid of this V1NetNamespace.
        NetID is the network identifier of the network namespace assigned to each overlay network packet. This can be manipulated with the \"oc adm pod-network\" commands.

        :return: The netid of this V1NetNamespace.
        :rtype: int
        """
        return self._netid

    @netid.setter
    def netid(self, netid):
        """
        Sets the netid of this V1NetNamespace.
        NetID is the network identifier of the network namespace assigned to each overlay network packet. This can be manipulated with the \"oc adm pod-network\" commands.

        :param netid: The netid of this V1NetNamespace.
        :type: int
        """
        if netid is None:
            raise ValueError("Invalid value for `netid`, must not be `None`")

        self._netid = netid

    @property
    def netname(self):
        """
        Gets the netname of this V1NetNamespace.
        NetName is the name of the network namespace. (This is the same as the object's name, but both fields must be set.)

        :return: The netname of this V1NetNamespace.
        :rtype: str
        """
        return self._netname

    @netname.setter
    def netname(self, netname):
        """
        Sets the netname of this V1NetNamespace.
        NetName is the name of the network namespace. (This is the same as the object's name, but both fields must be set.)

        :param netname: The netname of this V1NetNamespace.
        :type: str
        """
        if netname is None:
            raise ValueError("Invalid value for `netname`, must not be `None`")

        self._netname = netname

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V1NetNamespace):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
