#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from xld.kubernetes.ingress.helper import IngressHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

container_helper = ContainerHelperFactory(deployed.container).create()
if bool(deployed.defaultServiceName) != bool(deployed.defaultServicePort):
    if bool(deployed.defaultServiceName):
        raise RuntimeError('Default service name cannot be left empty while configuring default service.')
    else:
        raise RuntimeError('Default service port cannot be left empty while configuring default service.')

context.addStepWithCheckpoint(steps.jython(
    description="Create ingress {0} on {1}".format(IngressHelper.get_name(deployed),
                                                   container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/ingress/create_ingress.py",
    order=69
), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Wait for ingress {0} to be created completely.".format(
        IngressHelper.get_name(deployed)),
    script="xld/kubernetes/ingress/wait_for_creation_updation.py",
    order=70
), delta)
