#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from kubernetes import client
from xld.kubernetes import KubernetesBaseClient


class KubernetesBatchClient(KubernetesBaseClient):

    API_NAME = 'batch'

    def __init__(self, container):
        super(KubernetesBatchClient, self).__init__(container)

    def get_batch_api(self):
        version = self.get_api_version()
        print ("[Using API Group version: {} for api: {}]".format(version, self.API_NAME))
        return self.get_version_client(version)

    def get_api_version(self):
        return self.get_preferred_version(self.API_NAME, ['create_namespaced_cron_job'])

    def read_cronjob(self, name, namespace):
        return self.get_batch_api().read_namespaced_cron_job(name=name, namespace=namespace)

    def create_cronjob(self, v1_cronjob, namespace):
        return self.get_batch_api().create_namespaced_cron_job(namespace=namespace, body=v1_cronjob)

    def remove_cronjob(self, name, namespace):
        body = client.V1DeleteOptions(orphan_dependents=False, grace_period_seconds=0)
        return self.get_batch_api().delete_namespaced_cron_job(name=name, body=body, namespace=namespace)

    def replace_cronjob(self, name, v1_cronjob, namespace):
        return self.get_batch_api().replace_namespaced_cron_job(namespace=namespace, body=v1_cronjob, name=name)
