#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.persistent_volume.helper import PersistentVolumeHelper

if PersistentVolumeHelper.get_name(previousDeployed) != PersistentVolumeHelper.get_name(deployed):
    raise RuntimeError('PersistentVolume name should not be modified.')

context.addStepWithCheckpoint(steps.jython(
    description="Modify PersistentVolume {}".format(PersistentVolumeHelper.get_name(deployed)),
    script="xld/kubernetes/persistent_volume/steps/modify.py",
    order=55
), delta)
