#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import sys

from xld.kubernetes import *
from xld.kubernetes.eks.eks_helper import EKSHelper

print "------------------"
print "Testing connection to Kubernetes Cluster {0}".format(thisCi.name)
print "------------------"
try:
    # AWS EKS - Get session token
    if thisCi.isEKS:
        print "Generating AWS k8s token.."
        helper = EKSHelper(thisCi.accessKey, thisCi.accessSecret)
        token = helper.get_k8s_token(thisCi.clusterName, thisCi.regionName) if thisCi.regionName else helper.get_k8s_token(thisCi.clusterName)
        if token:
            thisCi.token = token
        else:
            raise RuntimeError("Cannot generate k8s token from AWS")

    with KubernetesBaseClient(thisCi) as client:
        versions = client.get_code_version()
        if versions is None:
            raise RuntimeError("Connection Unsuccessful !")
        print "Connection Successful !"
except Exception as e:
    message = ""
    if not ((thisCi.tlsCert and thisCi.tlsPrivateKey) or (thisCi.token) or
                (thisCi.username and thisCi.password)):
        message = "Authentication information is missing. "

    print "Connection Failed: {0}{1}".format(message, str(e))
    sys.exit(1)
