# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a client. By listing and beginning a watch from the returned resourceVersion, clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'metav1.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V1DeploymentConfigSpec(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'min_ready_seconds': 'int',
        'paused': 'bool',
        'replicas': 'int',
        'revision_history_limit': 'int',
        'selector': 'dict(str, str)',
        'strategy': 'V1DeploymentStrategy',
        'template': 'V1PodTemplateSpec',
        'test': 'bool',
        'triggers': 'list[V1DeploymentTriggerPolicy]'
    }

    attribute_map = {
        'min_ready_seconds': 'minReadySeconds',
        'paused': 'paused',
        'replicas': 'replicas',
        'revision_history_limit': 'revisionHistoryLimit',
        'selector': 'selector',
        'strategy': 'strategy',
        'template': 'template',
        'test': 'test',
        'triggers': 'triggers'
    }

    def __init__(self, min_ready_seconds=None, paused=None, replicas=None, revision_history_limit=None, selector=None, strategy=None, template=None, test=None, triggers=None):
        """
        V1DeploymentConfigSpec - a model defined in Swagger
        """

        self._min_ready_seconds = None
        self._paused = None
        self._replicas = None
        self._revision_history_limit = None
        self._selector = None
        self._strategy = None
        self._template = None
        self._test = None
        self._triggers = None
        self.discriminator = None

        if min_ready_seconds is not None:
          self.min_ready_seconds = min_ready_seconds
        if paused is not None:
          self.paused = paused
        if replicas is not None:
          self.replicas = replicas
        if revision_history_limit is not None:
          self.revision_history_limit = revision_history_limit
        if selector is not None:
          self.selector = selector
        if strategy is not None:
          self.strategy = strategy
        if template is not None:
          self.template = template
        if test is not None:
          self.test = test
        if triggers is not None:
          self.triggers = triggers

    @property
    def min_ready_seconds(self):
        """
        Gets the min_ready_seconds of this V1DeploymentConfigSpec.
        MinReadySeconds is the minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)

        :return: The min_ready_seconds of this V1DeploymentConfigSpec.
        :rtype: int
        """
        return self._min_ready_seconds

    @min_ready_seconds.setter
    def min_ready_seconds(self, min_ready_seconds):
        """
        Sets the min_ready_seconds of this V1DeploymentConfigSpec.
        MinReadySeconds is the minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)

        :param min_ready_seconds: The min_ready_seconds of this V1DeploymentConfigSpec.
        :type: int
        """

        self._min_ready_seconds = min_ready_seconds

    @property
    def paused(self):
        """
        Gets the paused of this V1DeploymentConfigSpec.
        Paused indicates that the deployment config is paused resulting in no new deployments on template changes or changes in the template caused by other triggers.

        :return: The paused of this V1DeploymentConfigSpec.
        :rtype: bool
        """
        return self._paused

    @paused.setter
    def paused(self, paused):
        """
        Sets the paused of this V1DeploymentConfigSpec.
        Paused indicates that the deployment config is paused resulting in no new deployments on template changes or changes in the template caused by other triggers.

        :param paused: The paused of this V1DeploymentConfigSpec.
        :type: bool
        """

        self._paused = paused

    @property
    def replicas(self):
        """
        Gets the replicas of this V1DeploymentConfigSpec.
        Replicas is the number of desired replicas.

        :return: The replicas of this V1DeploymentConfigSpec.
        :rtype: int
        """
        return self._replicas

    @replicas.setter
    def replicas(self, replicas):
        """
        Sets the replicas of this V1DeploymentConfigSpec.
        Replicas is the number of desired replicas.

        :param replicas: The replicas of this V1DeploymentConfigSpec.
        :type: int
        """

        self._replicas = replicas

    @property
    def revision_history_limit(self):
        """
        Gets the revision_history_limit of this V1DeploymentConfigSpec.
        RevisionHistoryLimit is the number of old ReplicationControllers to retain to allow for rollbacks. This field is a pointer to allow for differentiation between an explicit zero and not specified. Defaults to 10. (This only applies to DeploymentConfigs created via the new group API resource, not the legacy resource.)

        :return: The revision_history_limit of this V1DeploymentConfigSpec.
        :rtype: int
        """
        return self._revision_history_limit

    @revision_history_limit.setter
    def revision_history_limit(self, revision_history_limit):
        """
        Sets the revision_history_limit of this V1DeploymentConfigSpec.
        RevisionHistoryLimit is the number of old ReplicationControllers to retain to allow for rollbacks. This field is a pointer to allow for differentiation between an explicit zero and not specified. Defaults to 10. (This only applies to DeploymentConfigs created via the new group API resource, not the legacy resource.)

        :param revision_history_limit: The revision_history_limit of this V1DeploymentConfigSpec.
        :type: int
        """

        self._revision_history_limit = revision_history_limit

    @property
    def selector(self):
        """
        Gets the selector of this V1DeploymentConfigSpec.
        Selector is a label query over pods that should match the Replicas count.

        :return: The selector of this V1DeploymentConfigSpec.
        :rtype: dict(str, str)
        """
        return self._selector

    @selector.setter
    def selector(self, selector):
        """
        Sets the selector of this V1DeploymentConfigSpec.
        Selector is a label query over pods that should match the Replicas count.

        :param selector: The selector of this V1DeploymentConfigSpec.
        :type: dict(str, str)
        """

        self._selector = selector

    @property
    def strategy(self):
        """
        Gets the strategy of this V1DeploymentConfigSpec.
        Strategy describes how a deployment is executed.

        :return: The strategy of this V1DeploymentConfigSpec.
        :rtype: V1DeploymentStrategy
        """
        return self._strategy

    @strategy.setter
    def strategy(self, strategy):
        """
        Sets the strategy of this V1DeploymentConfigSpec.
        Strategy describes how a deployment is executed.

        :param strategy: The strategy of this V1DeploymentConfigSpec.
        :type: V1DeploymentStrategy
        """

        self._strategy = strategy

    @property
    def template(self):
        """
        Gets the template of this V1DeploymentConfigSpec.
        Template is the object that describes the pod that will be created if insufficient replicas are detected.

        :return: The template of this V1DeploymentConfigSpec.
        :rtype: V1PodTemplateSpec
        """
        return self._template

    @template.setter
    def template(self, template):
        """
        Sets the template of this V1DeploymentConfigSpec.
        Template is the object that describes the pod that will be created if insufficient replicas are detected.

        :param template: The template of this V1DeploymentConfigSpec.
        :type: V1PodTemplateSpec
        """

        self._template = template

    @property
    def test(self):
        """
        Gets the test of this V1DeploymentConfigSpec.
        Test ensures that this deployment config will have zero replicas except while a deployment is running. This allows the deployment config to be used as a continuous deployment test - triggering on images, running the deployment, and then succeeding or failing. Post strategy hooks and After actions can be used to integrate successful deployment with an action.

        :return: The test of this V1DeploymentConfigSpec.
        :rtype: bool
        """
        return self._test

    @test.setter
    def test(self, test):
        """
        Sets the test of this V1DeploymentConfigSpec.
        Test ensures that this deployment config will have zero replicas except while a deployment is running. This allows the deployment config to be used as a continuous deployment test - triggering on images, running the deployment, and then succeeding or failing. Post strategy hooks and After actions can be used to integrate successful deployment with an action.

        :param test: The test of this V1DeploymentConfigSpec.
        :type: bool
        """

        self._test = test

    @property
    def triggers(self):
        """
        Gets the triggers of this V1DeploymentConfigSpec.
        Triggers determine how updates to a DeploymentConfig result in new deployments. If no triggers are defined, a new deployment can only occur as a result of an explicit client update to the DeploymentConfig with a new LatestVersion. If null, defaults to having a config change trigger.

        :return: The triggers of this V1DeploymentConfigSpec.
        :rtype: list[V1DeploymentTriggerPolicy]
        """
        return self._triggers

    @triggers.setter
    def triggers(self, triggers):
        """
        Sets the triggers of this V1DeploymentConfigSpec.
        Triggers determine how updates to a DeploymentConfig result in new deployments. If no triggers are defined, a new deployment can only occur as a result of an explicit client update to the DeploymentConfig with a new LatestVersion. If null, defaults to having a config change trigger.

        :param triggers: The triggers of this V1DeploymentConfigSpec.
        :type: list[V1DeploymentTriggerPolicy]
        """

        self._triggers = triggers

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V1DeploymentConfigSpec):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
