#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.storage_class.helper import StorageClassHelper

storage_class_helper = StorageClassHelper(deployed)
storage_class_helper.should_not_modify_name(previous_deployed=previousDeployed)
storage_class_helper.should_not_modify_provisioner(previous_deployed=previousDeployed)
storage_class_helper.should_not_modify_parameters(previous_deployed=previousDeployed)
storage_class_helper.should_not_modify_reclaim_policy(previous_deployed=previousDeployed)

context.addStepWithCheckpoint(steps.jython(
    description="Modify StorageClass {} on {}".format(StorageClassHelper.get_name(deployed), deployed.container.name),
    script="xld/kubernetes/storage_class/steps/modify.py",
    order=52
), delta)
