#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

from xld.kubernetes.factories.handler_factory import ResourceFactoryResolver

result = "SUCCESS"

resolver = ResourceFactoryResolver(deployed)
resource_factory = resolver.get_factory()
container_helper = ContainerHelperFactory(deployed.container).create()

with resource_factory.get(data) as provider:
    resources = provider.filter_resources_by_definition(
        namespace=container_helper.get_container_name(deployed.container),
        resource_definition=data)

if resources.kind == "PodList":
    retry_count = 0
    starting_pods = [pod for pod in resources.items if pod.status.phase != "Running"]
    if len(starting_pods) > 0 and retry_count < deployed.resourceWaitTime:
        print("Waiting for Pod to be activated ...")
        result = "RETRY"
        retry_count += 1
elif resources.kind == "RouteList":
    retry_count = 0
    for item in resources.items:
        for ingress in item.status.ingress:
            for condition in ingress.conditions:
                if condition.type == "Admitted" and condition.status == "Unknown" and retry_count < deployed.resourceWaitTime:
                    print("Waiting for Route to be activated ...")
                    result = "RETRY"
                    retry_count = retry_count + 1
elif resources.kind == "DeploymentConfigList":
    retry_count = 0
    for item in resources.items:
        for trigger in item.spec.triggers:
            if trigger.imageChangeParams and trigger.imageChangeParams.automatic:
                if item.status.readyReplicas is None or item.status.readyReplicas < item.spec.replicas:
                    print("Waiting for DeploymentConfig's pod {0} to be in running state".format(item.metadata.name))
                    result = "RETRY"
                    retry_count = retry_count + 1

elif resources.kind in ["ConfigMapList", "SecretList", "CronJobList"]:
    retry_count = 0
    if not bool(resources.items) and retry_count < deployed.resourceWaitTime:
        result = "RETRY"
        retry_count += 1
elif resources.kind == 'PersistentVolumeClaimList':
    retry_count = 0
    for pv_claim in resources.items:
        if pv_claim.status.phase != 'Bound' and retry_count < deployed.resourceWaitTime:
            print("Waiting for PersistentVolumeClaim to be in Bound phase ...")
            result = "RETRY"
            retry_count = retry_count + 1
