#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

from xld.kubernetes.factories.handler_factory import ResourceFactoryResolver
from xld.kubernetes.resource.helper import ResourceHelper


class ResourceService:
    def __init__(self, deployed):
        self.__deployed = deployed
        self.__container_helper = ContainerHelperFactory(deployed.container).create()
        self.__resource_factory = ResourceFactoryResolver(deployed).get_factory()
        self.__data = ResourceHelper(deployed).parse()

    def create(self, item):
        print "Creating resource {0} on {1} {2}".format(item['kind'], self.__container_helper.get_container_name(
            self.__deployed.container),
                                                        self.__deployed.container)
        with self.__resource_factory.get(item) as resource:
            resource.create(namespace=self.__container_helper.get_container_name(self.__deployed.container),
                            resource_definition=item)

    def update(self, item):
        print "Updating resource {0} on {1}".format(item['kind'], self.__container_helper.get_container_name(
            self.__deployed.container),
                                                    self.__deployed.container)
        with self.__resource_factory.get(item) as resource:
            resource.modify(namespace=self.__container_helper.get_container_name(self.__deployed.container),
                            resource_definition=item)

    def delete(self, item):
        print "Deleting resource {0} on {1}".format(item['kind'], self.__container_helper.get_container_name(
            self.__deployed.container),
                                                    self.__deployed.container)
        with self.__resource_factory.get(item) as resource:
            resource.delete(namespace=self.__container_helper.get_container_name(self.__deployed.container),
                            resource_definition=item)

    def is_resource_deleted(self, item):
        with self.__resource_factory.get(item) as resource_provider:
            resources = resource_provider.filter_resources_by_definition(
                namespace=self.__container_helper.get_container_name(self.__deployed.container),
                resource_definition=item)
        return 'items' not in dir(resources) or not bool(resources.items)
