#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import sys

from xld.kubernetes import *
from xld.kubernetes.eks.eks_helper import EKSHelper

from xld.kubernetes.core_api_client import KubernetesCoreClient


print "------------------"
print "Describing Service {0}".format(thisCi.name)
print "------------------"
try:
    # AWS EKS - Get session token
    if thisCi.isEKS:
        print "Generating AWS k8s token.."
        helper = EKSHelper(thisCi.accessKey, thisCi.accessSecret)
        token = helper.get_k8s_token(thisCi.clusterName, thisCi.regionName) if thisCi.regionName else helper.get_k8s_token(thisCi.clusterName)
        if token:
            thisCi.token = token
        else:
            raise RuntimeError("Cannot generate k8s token from AWS")

    client = KubernetesCoreClient(thisCi)
    service_response = client.read_namespaced_service(params.serviceName,params.namespace)
    if service_response is False:
        raise RuntimeError("Service not available or ready !")
    else:
        if service_response.status.load_balancer.ingress is None:
            raise RuntimeError("Load Balancer not ready!")
        else:
            ingress = service_response.status.load_balancer.ingress
            for V1LoadBalancerIngress in ingress:
                for key, value in V1LoadBalancerIngress.__dict__.items():
                    print "%s:%s" % (key.strip("_"),value)

except Exception as e:
    print "Describing service failed. {0}".format(str(e))
    sys.exit(1)


