#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.statefulset.statefulset_helper import StatefulSetHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper
from xld.kubernetes.service.exposedservices.service_steps_helper import ExposedServiceStepsHelper

StatefulSetHelper.enrich_app_selectors(deployed)
container_helper = ContainerHelperFactory(deployed.container).create()
PodHelper.validate_pod(deployed_pod=deployed)
statefulset_helper = StatefulSetHelper()
statefulset_helper.validate_statefulset(deployed_statefulset=deployed)

if statefulset_helper.get_statefulset_name(previousDeployed) != statefulset_helper.get_statefulset_name(deployed):
    raise RuntimeError('StatefulSet name should not be modified.')
if previousDeployed.serviceName != deployed.serviceName:
    raise RuntimeError('StatefulSet service name should not be modified.')
if previousDeployed.podManagementPolicy != deployed.podManagementPolicy:
    raise RuntimeError('StatefulSet pod management policy should not be modified.')
if previousDeployed.revisionHistoryLimit != deployed.revisionHistoryLimit:
    raise RuntimeError('StatefulSet revision history limit should not be modified.')


context.addStepWithCheckpoint(steps.jython(
    description="{0} StatefulSet {1} on {2}".format(
        'Modify', StatefulSetHelper().get_statefulset_name(deployed),
        container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/statefulset/modify_statefulset.py",
    order=65
), delta)

if deployed.minimumPodCount > 0:
    context.addStepWithCheckpoint(steps.jython(
        description="Wait for StatefulSet {0} to be in running state".format(statefulset_helper.get_statefulset_name(deployed)),
        script="xld/kubernetes/statefulset/wait_for_statefulset_ready_on_modify.py",
        order=66
    ), delta)

old_services = ExposedServiceStepsHelper.get_exposed_services(previousDeployed.containers,previousDeployed.labels,
                                                              statefulset_helper.get_statefulset_name(previousDeployed))
new_services = ExposedServiceStepsHelper.get_exposed_services(deployed.containers,deployed.labels,
                                                              statefulset_helper.get_statefulset_name(deployed))
ExposedServiceStepsHelper(context, steps).add_modify_steps(deployed, previousDeployed, old_services, new_services, delta)
