#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from xld.kubernetes.factories.handler_factory import ResourceFactoryResolver, ContainerHelperFactory

result = "SUCCESS"
container_helper = ContainerHelperFactory(deployed.container).create()
provider = ResourceFactoryResolver(deployed).get_factory().get(data)
resources = provider.filter_resources_by_definition(namespace=container_helper.get_container_name(deployed.container),
                                                    resource_definition=data)

# hack method to fail process if pods are not at a ready status. result 'FAIL' does not work
def processFail():
    print ("None of the pods were at a ready status after reaching the max number of retries. \n")
    raise Exception(
        "Max number of retries reached. Please verify if readiness probe check is correct or increase the number 'Readiness Probe Retry' in ci properties... \n")
    # fails the deployment here
    exit(1)

for item in resources.items:
    print("#####")
    kind = resources.kind.replace("List", "")
    print("{0} Status:".format(kind))
    print("- Replica(s) wanted: %s" % item.spec.replicas)
    print("- readyReplicas: %s" % item.status.readyReplicas)
    print("- updatedReplicas: %s" % item.status.updatedReplicas)
    print("- unavailableReplicas: %s" % item.status.unavailableReplicas)
    print("- availableReplicas: %s" % item.status.availableReplicas)
    if item.status.readyReplicas != item.spec.replicas or item.status.unavailableReplicas > 0:
        if deployed.readinessProbeRetry > 0:
            print("Waiting for {3}'s {0} to have pods in running state, retries left: {1} (Approx {2} seconds)".format(data['metadata']['name'],deployed.readinessProbeRetry, deployed.readinessProbeRetry * 5, kind))
            deployed.readinessProbeRetry -= 1
            result = "RETRY"
        else:
            processFail()

