#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.service.service_helper import ServiceHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

if not deployed.ports:
    raise RuntimeError("Service ports are required.")

if deployed.serviceType == 'ExternalName':
    if not deployed.externalName:
        raise RuntimeError("Service external name is required.")
    if deployed.clusterIP:
        raise RuntimeError("Cluster IP should not be provided for external service.")

container_helper = ContainerHelperFactory(deployed.container).create()

context.addStepWithCheckpoint(steps.jython(
    description="{0} Service {1} on {2}".format(
        'Modify' if previousDeployed else 'Create', ServiceHelper().get_service_name(deployed),
        container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/service/%s" % ('modify_service.py' if previousDeployed else 'create_service.py'),
    order=63
), delta)

# Wait step only for create service
if not previousDeployed:
    context.addStep(steps.jython(
        description="Wait for Service to be {0}".format("modified" if previousDeployed else "created"),
        script="xld/kubernetes/service/wait_for_service_creation.py",
        order=64
    ))
