#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper


class PodsStepsGenerator(object):
    def __init__(self, context, steps):
        self.__context = context
        self.__steps = steps

    def replace(self, delta, deployed, previousDeployed):
        container_helper = ContainerHelperFactory(deployed.container).create()
        self.__context.addStepWithCheckpoint(self.__steps.jython(
            description="Destroy Pod {0} from {1}".format(PodHelper.get_pod_name(previousDeployed),
                                                          container_helper.get_container_name(
                                                              previousDeployed.container)),
            script="xld/kubernetes/pod/remove_pod.py",
            jython_context={"deployed": deployed, "previousDeployed": previousDeployed},
            order=39
        ), delta)
        self.__context.addStepWithCheckpoint(self.__steps.jython(
            description="Wait for Pod {0} to be destroyed completely".format(PodHelper.get_pod_name(previousDeployed)),
            script="xld/kubernetes/pod/wait_for_pod_deletion.py",
            jython_context={"deployed": deployed, "previousDeployed": previousDeployed},
            order=40
        ), delta)
        self.__context.addStepWithCheckpoint(self.__steps.jython(
            description="Create Pod {0} on {1} {2}".format(PodHelper.get_pod_name(deployed),
                                                           container_helper.get_container_label(),
                                                           container_helper.get_container_name(deployed.container)),
            script="xld/kubernetes/pod/create_pod.py",
            jython_context={"deployed": deployed, "previousDeployed": previousDeployed},
            order=61
        ), delta)
        self.__context.addStepWithCheckpoint(self.__steps.jython(
            description="Wait for Pod {0} to be in running state".format(PodHelper.get_pod_name(deployed)),
            script="xld/kubernetes/pod/wait_for_pod_creation.py",
            jython_context={"deployed": deployed, "previousDeployed": previousDeployed},
            order=62
        ), delta)
