from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.secret.secret_helper import SecretHelper

container_helper = ContainerHelperFactory(previousDeployed.container).create()
secret_name = SecretHelper().get_secret_name(previousDeployed)

context.addStepWithCheckpoint(steps.jython(
    description="Destroy Secret {0} from {1}".format(secret_name, container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/secret/remove_secret.py",
    order=51
), delta)

# Wait for secret delete
context.addStep(steps.jython(
    description="Wait for Secret {0} to be destroyed completely".format(secret_name),
    script="xld/kubernetes/secret/wait_for_secret_deletion.py",
    order=52
))
