from xld.kubernetes.core_api_client import KubernetesCoreClient
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.namespace.namespace_helper import NamespaceHelper


class NamespaceService:
    def __init__(self):
        self.__namespace_helper = NamespaceHelper()

    def create_namespace(self, deployed):
        client = NamespaceService.__create_client(deployed.container)
        request_create_namespace = self.__create_container_helper(deployed).read_namespace(
            deployed_namespace=deployed)
        print("Creating namespace '{0}' on Kubernetes Master '{1}' ".format(request_create_namespace.metadata.name,
                                                                            deployed.container.name))
        client.create_namespace(request_create_namespace)

    def destroy_namespace(self, previous_deployed):
        client = NamespaceService.__create_client(previous_deployed.container)
        print "Destroying {0} '{1}' ".format(
            self.__namespace_helper.get_container_label(), self.__namespace_helper.get_container_name(previous_deployed))
        client.remove_namespace(self.__namespace_helper.get_container_name(previous_deployed))

    def should_wait_for_namespace_deletion(self, previous_deployed):
        client = NamespaceService.__create_client(previous_deployed.container)
        if client.is_namespace_existing(self.__namespace_helper.get_container_name(previous_deployed)):
            print "Waiting for namespace {0} to be destroyed.".format(
                self.__namespace_helper.get_container_name(previous_deployed))
            return True
        return False

    @staticmethod
    def __create_client(container):
        return KubernetesCoreClient(container)

    @staticmethod
    def __create_container_helper(deployed):
        return ContainerHelperFactory(container=deployed).create()
