from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.persistent_volume_claim.helper import PVCHelper

container_helper = ContainerHelperFactory(previousDeployed.container).create()
pv_claim_name = PVCHelper.get_name(previousDeployed)

context.addStepWithCheckpoint(steps.jython(
    description="Destroy PersistentVolumeClaim {0} from {1}".format(pv_claim_name,
                                                                      container_helper.get_container_name(
                                                                          previousDeployed.container)),
    script="xld/kubernetes/persistent_volume_claim/steps/destroy.py",
    order=51
), delta)

context.addStep(steps.jython(
    description="Wait for PersistentVolumeClaim {0} to be destroyed completely".format(pv_claim_name),
    script="xld/kubernetes/persistent_volume_claim/steps/wait_for_deletion.py",
    order=52
))
