from kubernetes import client


class ConfigMapHelper(object):
    @staticmethod
    def read_config_map(deployed):
        v1_config_map = client.V1ConfigMap()
        v1_config_map.metadata = client.V1ObjectMeta(name=ConfigMapHelper.get_config_map_name(deployed))
        v1_config_map.data = deployed.data.copy()
        v1_config_map.data.update(ConfigMapHelper.get_config_map_files(deployed.propertyFiles))
        return v1_config_map

    @staticmethod
    def get_config_map_name(deployed):
        return deployed.configMapName if deployed.configMapName else deployed.name

    @staticmethod
    def get_config_map_files(deployed_files):
        return dict((deployed_file.file.name, open(deployed_file.file.path).read()) for deployed_file in deployed_files)
