from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.config_map.helper import ConfigMapHelper

container_helper = ContainerHelperFactory(deployed.container).create()

if deployed.configMapName != previousDeployed.configMapName:
    raise RuntimeError('Name of ConfigMap cannot be modified.')

context.addStepWithCheckpoint(steps.jython(
    description="Modify ConfigMap {} on {}".format(ConfigMapHelper().get_config_map_name(deployed),
                                                    container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/config_map/modify.py",
    order=59
), delta)
