from kubernetes import client
from kubernetes.client.rest import ApiException
from xld.kubernetes import KubernetesBaseClient


class KubernetesAppsClient(KubernetesBaseClient):

    def __init__(self, container):
        super(KubernetesAppsClient, self).__init__(container)

    def get_apps_api(self):
        return client.ExtensionsV1beta1Api(self.internal_api_client)

    def read_deployment(self, name, namespace):
        return self.get_apps_api().read_namespaced_deployment(name=name, namespace=namespace)

    def create_deployment(self, v1_deployment, namespace):
        return self.get_apps_api().create_namespaced_deployment(namespace=namespace, body=v1_deployment)

    def remove_deployment(self, name, namespace):
        body = client.V1DeleteOptions(orphan_dependents=False, grace_period_seconds=0)
        return self.get_apps_api().delete_namespaced_deployment(name=name, body=body, namespace=namespace)

    def replace_deployment(self, name,  v1_deployment, namespace):
        return self.get_apps_api().replace_namespaced_deployment(namespace=namespace, body=v1_deployment, name=name)

    def is_deployment_existing(self, name, namespace):
        try:
            deployment = self.read_deployment(name=name, namespace=namespace)
            if deployment:
                return True
        except ApiException as e:
            if e.status == 404:
                return False
