from xld.kubernetes.core_api_client import KubernetesCoreClient
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper


class PodService(object):
    def __init__(self):
        self.__pod_helper = PodHelper()

    def create_pod(self, deployed):
        client = self.__create_client(deployed.container.container)
        request_pod = self.__pod_helper.read_pod(deployed_pod=deployed)
        container_helper = self.__create_container_helper(deployed.container)
        print("Creating Pod '{0}' in {1} '{2}' ".format(request_pod['metadata']['name'],
                                                        container_helper.get_container_label(),
                                                        container_helper.get_container_name(
                                                            deployed.container)))
        response_pod = client.create_pod(request_pod,
                                         container_helper.get_container_name(
                                             deployed.container))
        deployed.podName = response_pod.metadata.name

    def destroy_pod(self, previousDeployed):
        client = self.__create_client(previousDeployed.container.container)
        container_helper = self.__create_container_helper(previousDeployed.container)
        if client.is_pod_existing(self.__pod_helper.get_pod_name(previousDeployed),
                                  container_helper.get_container_name(
                                      previousDeployed.container)):
            print "Destroying pod '{0}' from {1} '{2}' ".format(self.__pod_helper.get_pod_name(previousDeployed),
                                                                container_helper.get_container_label(),
                                                                container_helper.get_container_name(
                                                                    previousDeployed.container))
            client.remove_pod(self.__pod_helper.get_pod_name(previousDeployed),
                              container_helper.get_container_name(
                                  previousDeployed.container))
        else:
            print "Pod '{0}' in {1} '{2}'  is already removed".format(
                self.__pod_helper.get_pod_name(previousDeployed),
                container_helper.get_container_label(),
                container_helper.get_container_name(
                    previousDeployed.container))

    def should_wait_for_creation(self, context, deployed):
        client = self.__create_client(deployed.container.container)
        container_helper = self.__create_container_helper(deployed.container)
        counter_name = "retry_{0}_{1}".format(self.__pod_helper.get_pod_name(deployed),
                                              container_helper.get_container_name(
                                                  deployed.container))
        retry_counter = context.getAttribute(counter_name) if context.getAttribute(counter_name) else 1
        if retry_counter <= deployed.podCreateDeleteRetryCount:
            if client.is_pod_existing(self.__pod_helper.get_pod_name(deployed),
                                      container_helper.get_container_name(
                                          deployed.container)):
                if not client.is_pod_status_ready(self.__pod_helper.get_pod_name(deployed),
                                             deployed.container):
                    print("Waiting for pod {0} to be in healthy state".format(self.__pod_helper.get_pod_name(deployed)))
                    context.setAttribute(counter_name, retry_counter + 1)
                    return True
                else:
                    return False
            else:
                raise Exception('Error creating pod on xld.kubernetes')
        else:
            context.setAttribute(counter_name, 0)
            raise Exception('Step retry timed out.')

    def should_wait_for_deletion(self, context, previousDeployed):
        client = self.__create_client(previousDeployed.container.container)
        container_helper = self.__create_container_helper(previousDeployed.container)
        counter_name = "retry_{0}_{1}".format(self.__pod_helper.get_pod_name(previousDeployed),
                                              container_helper.get_container_name(
                                                  previousDeployed.container))
        retry_counter = context.getAttribute(counter_name)
        if not retry_counter:
            retry_counter = 1
        if retry_counter <= previousDeployed.podCreateDeleteRetryCount:
            if client.is_pod_existing(self.__pod_helper.get_pod_name(previousDeployed),
                                      container_helper.get_container_name(
                                          previousDeployed.container)):
                print "Waiting for pod {0} to be deleted.".format(self.__pod_helper.get_pod_name(previousDeployed))
                context.setAttribute(counter_name, retry_counter + 1)
                return True
            else:
                return False
        else:
            context.setAttribute(counter_name, 0)
            raise Exception('Step retry timed out.')

    @staticmethod
    def __create_client(container):
        return KubernetesCoreClient(container)

    @staticmethod
    def __create_container_helper(container):
        return ContainerHelperFactory(container).create()
