from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper

container_helper = ContainerHelperFactory(previousDeployed.container).create()

context.addStepWithCheckpoint(steps.jython(
    description="Destroy pod {0} from {1}".format(PodHelper.get_pod_name(previousDeployed), container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/pod/remove_pod.py",
    order=49
), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Wait for pod {0} to be fully destroyed".format(PodHelper.get_pod_name(previousDeployed)),
    script="xld/kubernetes/pod/wait_for_pod_deletion.py",
    order=50
), delta)
