# coding: utf-8

"""
    Kubernetes

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1.5.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V2alpha1CronJobSpec(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, concurrency_policy=None, job_template=None, schedule=None, starting_deadline_seconds=None, suspend=None):
        """
        V2alpha1CronJobSpec - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'concurrency_policy': 'str',
            'job_template': 'V2alpha1JobTemplateSpec',
            'schedule': 'str',
            'starting_deadline_seconds': 'int',
            'suspend': 'bool'
        }

        self.attribute_map = {
            'concurrency_policy': 'concurrencyPolicy',
            'job_template': 'jobTemplate',
            'schedule': 'schedule',
            'starting_deadline_seconds': 'startingDeadlineSeconds',
            'suspend': 'suspend'
        }

        self._concurrency_policy = concurrency_policy
        self._job_template = job_template
        self._schedule = schedule
        self._starting_deadline_seconds = starting_deadline_seconds
        self._suspend = suspend

    @property
    def concurrency_policy(self):
        """
        Gets the concurrency_policy of this V2alpha1CronJobSpec.
        ConcurrencyPolicy specifies how to treat concurrent executions of a Job.

        :return: The concurrency_policy of this V2alpha1CronJobSpec.
        :rtype: str
        """
        return self._concurrency_policy

    @concurrency_policy.setter
    def concurrency_policy(self, concurrency_policy):
        """
        Sets the concurrency_policy of this V2alpha1CronJobSpec.
        ConcurrencyPolicy specifies how to treat concurrent executions of a Job.

        :param concurrency_policy: The concurrency_policy of this V2alpha1CronJobSpec.
        :type: str
        """

        self._concurrency_policy = concurrency_policy

    @property
    def job_template(self):
        """
        Gets the job_template of this V2alpha1CronJobSpec.
        JobTemplate is the object that describes the job that will be created when executing a CronJob.

        :return: The job_template of this V2alpha1CronJobSpec.
        :rtype: V2alpha1JobTemplateSpec
        """
        return self._job_template

    @job_template.setter
    def job_template(self, job_template):
        """
        Sets the job_template of this V2alpha1CronJobSpec.
        JobTemplate is the object that describes the job that will be created when executing a CronJob.

        :param job_template: The job_template of this V2alpha1CronJobSpec.
        :type: V2alpha1JobTemplateSpec
        """
        if job_template is None:
            raise ValueError("Invalid value for `job_template`, must not be `None`")

        self._job_template = job_template

    @property
    def schedule(self):
        """
        Gets the schedule of this V2alpha1CronJobSpec.
        Schedule contains the schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.

        :return: The schedule of this V2alpha1CronJobSpec.
        :rtype: str
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """
        Sets the schedule of this V2alpha1CronJobSpec.
        Schedule contains the schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.

        :param schedule: The schedule of this V2alpha1CronJobSpec.
        :type: str
        """
        if schedule is None:
            raise ValueError("Invalid value for `schedule`, must not be `None`")

        self._schedule = schedule

    @property
    def starting_deadline_seconds(self):
        """
        Gets the starting_deadline_seconds of this V2alpha1CronJobSpec.
        Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.

        :return: The starting_deadline_seconds of this V2alpha1CronJobSpec.
        :rtype: int
        """
        return self._starting_deadline_seconds

    @starting_deadline_seconds.setter
    def starting_deadline_seconds(self, starting_deadline_seconds):
        """
        Sets the starting_deadline_seconds of this V2alpha1CronJobSpec.
        Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.

        :param starting_deadline_seconds: The starting_deadline_seconds of this V2alpha1CronJobSpec.
        :type: int
        """

        self._starting_deadline_seconds = starting_deadline_seconds

    @property
    def suspend(self):
        """
        Gets the suspend of this V2alpha1CronJobSpec.
        Suspend flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.

        :return: The suspend of this V2alpha1CronJobSpec.
        :rtype: bool
        """
        return self._suspend

    @suspend.setter
    def suspend(self, suspend):
        """
        Sets the suspend of this V2alpha1CronJobSpec.
        Suspend flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.

        :param suspend: The suspend of this V2alpha1CronJobSpec.
        :type: bool
        """

        self._suspend = suspend

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
