#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import sys

from xld.kubernetes import *
from xld.kubernetes.eks.eks_helper import EKSHelper
from xld.kubernetes.gke.gke_helper import GKEHelper

master = thisCi.container
print "------------------"
print "Testing connection to Kubernetes Cluster {0}".format(master.name)
print "------------------"
try:
    # AWS EKS - Get session token
    if master.isEKS:
        print "Generating AWS k8s token.."
        if master.sessionToken is None:
            helper = EKSHelper(master.accessKey, master.accessSecret, master.isAssumeRole, master.accountId, master.roleName, master.durationSeconds)
        else:
            helper = EKSHelper(master.accessKey, master.accessSecret, master.isAssumeRole, master.accountId, master.roleName, master.durationSeconds, master.sessionToken, master.roleArn)
        token = helper.get_k8s_token(master.clusterName, master.useGlobal, region_name=master.regionName)
        if token:
            master.token = token
        else:
            raise RuntimeError("Cannot generate k8s token from AWS")

    # Google GKE - Get session token
    if master.isGKE:
        gke_helper = GKEHelper()
        gketoken = gke_helper.get_gke_token(master.clientEmail, master.privateKey, master.projectId)
        if gketoken:
            master.token = gketoken
        else:
            raise RuntimeError("Cannot generate k8s token from GKE")

    with KubernetesBaseClient(master, thisCi.token) as client:
        versions = client.get_code_version()
        if versions is None:
            raise RuntimeError("Connection Unsuccessful !")
        print "Connection Successful !"
except Exception as e:
    message = ""
    if not ((master.tlsCert and master.tlsPrivateKey) or (master.token) or
                (master.username and master.password)):
        message = "Authentication information is missing. "

    print "Connection Failed: {0}{1}".format(message, str(e))
    sys.exit(1)
