#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.statefulset.statefulset_helper import StatefulSetHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.service.exposedservices.service_steps_helper import ExposedServiceStepsHelper

container_helper = ContainerHelperFactory(previousDeployed.container).create()
statefulset_name = StatefulSetHelper().get_statefulset_name(previousDeployed)


context.addStepWithCheckpoint(steps.jython(
    description="Destroy StatefulSet {0} from {1}".format(statefulset_name, container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/statefulset/remove_statefulset.py",
    order=previousDeployed.destroyOrder
), delta)

# Wait for statefulset delete
context.addStepWithCheckpoint(steps.jython(
    description="Wait for StatefulSet {0} to be destroyed completely".format(statefulset_name),
    script="xld/kubernetes/statefulset/wait_for_statefulset_deletion.py",
    order=previousDeployed.destroyOrder + 1
), delta)

services = ExposedServiceStepsHelper.get_exposed_services(previousDeployed.containers,previousDeployed.labels,
                                                          StatefulSetHelper().get_statefulset_name(previousDeployed))
ExposedServiceStepsHelper(context, steps).add_destroy_steps(previousDeployed, services, delta)
