from xld.kubernetes.apps_api_client import KubernetesAppsClient

k8s_master = container.getProperty("k8sMaster")
api_client = KubernetesAppsClient(k8s_master)
inspected = inspectionContext.getInspected()
discovered_stateful_sets = []

for key in inspected:
    ci = inspected[key]
    if str(ci.type) == 'k8s.Namespace':

        namespaceName = ci.getProperty("namespaceName")
        if ci.getProperty("token"):
            api_client = KubernetesAppsClient(k8s_master, ci.getProperty("token"))
        statefulset_list = api_client.get_apps_api().list_namespaced_stateful_set(namespace=namespaceName)
        statefulsets = statefulset_list.items

        for statefulset in statefulsets:
            statefulset_name = statefulset.metadata.name
            statefulset_id = "%s/%s" % (ci.id, statefulset_name)
            service_ci = Type.valueOf("k8s.StatefulSet").descriptor.newInstance(statefulset_id)
            service_ci.setProperty("statefulSetName", statefulset_name)
            service_ci.setProperty("serviceName", statefulset.spec.service_name)
            service_ci.setProperty("podManagementPolicy", statefulset.spec.pod_management_policy)
            service_ci.setProperty("replicasCount", statefulset.spec.replicas)
            service_ci.setProperty("revisionHistoryLimit", statefulset.spec.revision_history_limit)
            service_ci.setProperty("strategyType", statefulset.spec.update_strategy.type)
            service_ci.setProperty("matchLabels", statefulset.spec.selector.match_labels)
            discovered_stateful_sets.append(service_ci)
            print("Discovered statefulset %s in namespace %s" % (statefulset_name, namespaceName))

for ci in discovered_stateful_sets:
    inspectionContext.discovered(ci)
    inspectionContext.inspected(ci)
