from xld.kubernetes.core_api_client import KubernetesCoreClient

k8s_master = container.getProperty("k8sMaster")
api_client = KubernetesCoreClient(k8s_master)
inspected = inspectionContext.getInspected()
discovered_configmaps = []

for key in inspected:
    ci = inspected[key]
    if str(ci.type) == 'k8s.Namespace':

        namespaceName = ci.getProperty("namespaceName")
        if ci.getProperty("token"):
            api_client = KubernetesCoreClient(k8s_master, ci.getProperty("token"))

        config_map_list = api_client.core_api.list_namespaced_config_map(namespace=namespaceName)
        configmaps = config_map_list.items

        for configmap_obj in configmaps:
            configmap_data = configmap_obj.data
            configmap_name = configmap_obj.metadata.name
            configmap_id = "%s/%s" % (ci.id, configmap_name)
            configmap_ci = Type.valueOf("k8s.ConfigMap").descriptor.newInstance(configmap_id)
            configmap_ci.setProperty("data", configmap_data)
            discovered_configmaps.append(configmap_ci)
            print("Discovered configmap %s in namespace %s" % (configmap_name, namespaceName))

for ci in discovered_configmaps:
    inspectionContext.discovered(ci)
    inspectionContext.inspected(ci)
