#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from kubernetes import client


class NamespaceHelper:
    def read_namespace(self, deployed_namespace):
        namespace = client.V1Namespace()
        namespace.metadata = client.V1ObjectMeta(name=NamespaceHelper.get_container_name(deployed_namespace))
        return namespace

    @staticmethod
    def get_container_name(container):
        return container.namespaceName if container.namespaceName else container.name

    @staticmethod
    def get_container_label():
        return "namespace"
