/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.kubernetes.inspect;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.BaseDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.kubernetes.inspect.DelegatedInspectionHelper;
import com.xebialabs.deployit.plugin.kubernetes.inspect.JythonInspectionStep;
import java.util.HashMap;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

@Metadata(virtual=true, inspectable=true)
public class InspectableContainer
extends BaseDeployedContainer {
    @Property(required=false)
    private String inspectionScript;
    @Property(hidden=true, defaultValue="k8s.ConfigMap,k8s.Pod,k8s.Service,k8s.Secret,k8s.Deployment,k8s.StatefulSet,k8s.PersistentVolumeClaim")
    private Set<String> deployedsToDiscover = Sets.newHashSet();

    @Inspect
    public void inspectContainer(InspectionContext ctx) {
        if (this.inspectionScript == null || this.inspectionScript.trim().length() == 0) {
            throw new IllegalArgumentException("Property 'inspectionScript' is required.");
        }
        if (this.getProperty("k8sMaster") == null) {
            throw new IllegalStateException("K8sMaster mandatory for discovery");
        }
        ScriptEngine engine = new ScriptEngineManager(Thread.currentThread().getContextClassLoader()).getEngineByName("jython");
        engine = new ScriptEngineManager().getEngineByName("python");
        if (engine == null) {
            throw new IllegalStateException("Could not find the python/jython, is it on the classpath?");
        }
        HashMap<String, Object> scriptContext = new HashMap<String, Object>();
        scriptContext.put("thisCi", (Object)this);
        JythonInspectionStep step = new JythonInspectionStep(this.inspectionScript, scriptContext, "Discover objects of type k8s.Namespace on " + this, engine);
        ctx.addStep((Step)step);
        Iterable typesToDiscovery = Iterables.transform(this.deployedsToDiscover, (Function)new Function<String, Type>(){

            public Type apply(String input) {
                return Type.valueOf((String)input);
            }
        });
        DelegatedInspectionHelper.discoverDeployeds(this, ctx, Lists.newArrayList((Iterable)typesToDiscovery), engine);
    }
}

