from xld.kubernetes.core_api_client import KubernetesCoreClient

k8s_master = container.getProperty("k8sMaster")
api_client = KubernetesCoreClient(k8s_master)
inspected = inspectionContext.getInspected()
discovered_service = []

for key in inspected:
    ci = inspected[key]
    if str(ci.type) == 'k8s.Namespace':

        namespaceName = ci.getProperty("namespaceName")
        if ci.getProperty("token"):
            api_client = KubernetesCoreClient(k8s_master, ci.getProperty("token"))
        service_list = api_client.core_api.list_namespaced_service(namespace=namespaceName)
        services = service_list.items

        for service in services:
            service_name = service.metadata.name
            service_id = "%s/%s" % (ci.id, service_name)
            service_ci = Type.valueOf("k8s.Service").descriptor.newInstance(service_id)
            service_ci.setProperty("serviceType", service.spec.type)
            service_ci.setProperty("clusterIP", service.spec.cluster_ip)
            service_ci.setProperty("externalIPs", service.spec.external_i_ps)
            service_ci.setProperty("externalName", service.spec.external_name)
            service_ci.setProperty("loadBalancerIP", service.spec.load_balancer_ip)
            service_ci.setProperty("loadBalancerSourceRanges", service.spec.load_balancer_source_ranges)
            service_ci.setProperty("selectors", service.spec.selector)
            service_ci.setProperty("sessionAffinity", service.spec.session_affinity)
            service_ci.setProperty("resourceVersion", service.metadata.resource_version)
            discovered_service.append(service_ci)
            print("Discovered service %s in namespace %s" % (service_name, namespaceName))

for ci in discovered_service:
    inspectionContext.discovered(ci)
    inspectionContext.inspected(ci)
