/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.kubernetes;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.kubernetes.inspect.JythonInspectionStep;
import com.xebialabs.deployit.plugin.proxy.ProxyServer;
import java.util.HashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, description="The controlling unit in a Kubernetes cluster which serves as the main management contact point for administrators.", inspectable=true)
public class Master
extends BaseContainer {
    @Property(hidden=true)
    public String clientFactory = "xld.kubernetes.factories.client_factory.KubernetesClientFactory";
    @Property(hidden=true)
    public String containerHelper = "xld.kubernetes.k8s_master_helper.K8sMasterHelper";
    @Property(label="API server URL", description="URL for RESTful interface provided by API Server, example https://cluster1.k8s.abc.org")
    public String apiServerURL;
    @Property(label="Skip TLS/SSL", defaultValue="false", description="Do not verify using TLS/SSL")
    public boolean skipTLS;
    @Property(label="Is AWS EKS", defaultValue="false", category="AWS EKS", description="If the k8s cluster is an AWS EKS cluster, fill access key and access secret instead of credentials")
    public boolean isEKS;
    @Property(label="Use Global STS", defaultValue="true", category="AWS EKS", description="Use global STS endpoint or regional for token generation")
    public boolean useGlobal;
    @Property(label="AWS STS region name", defaultValue="us-east-1", required=false, category="AWS EKS", description="AWS STS enabled region name to use, only needed when k8s cluster is an EKS cluster, defaults to 'us-east-1', leave blank if global STS is used")
    public String regionName;
    @Property(label="EKS cluster name", required=false, category="AWS EKS", description="EKS cluster name, only needed when k8s cluster is an EKS cluster")
    public String clusterName;
    @Property(label="AWS Access Key", required=false, category="AWS EKS", description="AWS access key, only needed when k8s cluster is an EKS cluster")
    public String accessKey;
    @Property(label="AWS Access Secret", password=true, required=false, category="AWS EKS", description="AWS access secret, only needed when k8s cluster is an EKS cluster")
    public String accessSecret;
    @Property(label="Is Assume Role", defaultValue="false", category="AWS EKS", description="If the EKS k8s cluster want to use assume role")
    public boolean isAssumeRole;
    @Property(label="Account Id", required=false, category="AWS EKS", description="Id or alias of aws account where assume role exists.")
    public String accountId;
    @Property(label="Role Name", required=false, category="AWS EKS", description="Role name that user wants to switch to.")
    public String roleName;
    @Property(label="Role Arn", required=false, category="AWS EKS", description="This field is required when roleArn has different principal policy than arn:aws:iam::'accountid':role/rolename")
    public String roleArn;
    @Property(label="Duration Seconds", required=false, category="AWS EKS", description="The duration, in seconds, of the role session. The value specified can can range from 900 seconds (15 minutes) up to the maximum session duration that is set for the role.")
    public int durationSeconds = 900;
    @Property(label="Session Token", required=false, category="AWS EKS", description="The session token of the temporary credential.")
    public String sessionToken;
    @Property(label="Is Google GKE", defaultValue="false", category="Google GKE", description="If the k8s cluster is an Google GKE cluster, fill PrivateKey , Client Email and ProjectID instead of credentials")
    public boolean isGKE;
    @Property(label="Google Project Id", required=false, category="Google GKE", description="GCP Project Id , only needed when k8s cluster is an GKE cluster")
    public String projectId;
    @Property(label="Google client Email", required=false, category="Google GKE", description="GCP client email, only needed when k8s cluster is an GKE cluster")
    public String clientEmail;
    @Property(label="CA certificate", required=false, size=Property.Size.LARGE, description="Certification authority certificate(ca.crt) for server")
    public String caCert;
    @Property(size=Property.Size.LARGE, label="Google Private Key", required=false, category="Google GKE", description="GCP private key, only needed when k8s cluster is an GKE cluster")
    public String privateKey;
    @Property(label="TLS certificate", required=false, size=Property.Size.LARGE, category="Client Certificate Authentication", description="TLS certificate for master server(apiserver.crt)")
    public String tlsCert;
    @Property(label="TLS private key", required=false, size=Property.Size.LARGE, category="Client Certificate Authentication", description="TLS private key for master server(apiserver.key)")
    public String tlsPrivateKey;
    @Property(label="Username", required=false, category="Username/password Authentication", description="Username with which to authenticate, if using username/password authentication.")
    public String username;
    @Property(label="Password", required=false, password=true, category="Username/password Authentication", description="Password with which to authenticate, if using username/password authentication.")
    public String password;
    @Property(label="Token", required=false, size=Property.Size.LARGE, password=true, category="Token Authentication", description="Authentication token, if using token based authentication.")
    public String token;
    @Property(defaultValue="false", description="Dump request/response for troubleshooting purposes.")
    public boolean debug;
    @Property(required=false)
    public ProxyServer proxyServer;
    @Property(required=false, defaultValue="xld/kubernetes/inspect-master.py")
    private String inspectionScript;

    @Inspect
    public void inspectContainer(InspectionContext ctx) {
        if (this.inspectionScript == null || this.inspectionScript.trim().length() == 0) {
            throw new IllegalArgumentException("Property 'inspectionScript' is required.");
        }
        ScriptEngine engine = new ScriptEngineManager(Thread.currentThread().getContextClassLoader()).getEngineByName("jython");
        engine = new ScriptEngineManager().getEngineByName("python");
        if (engine == null) {
            throw new IllegalStateException("Could not find the python/jython, is it on the classpath?");
        }
        HashMap<String, Object> scriptContext = new HashMap<String, Object>();
        scriptContext.put("thisCi", (Object)this);
        JythonInspectionStep step = new JythonInspectionStep(this.inspectionScript, scriptContext, "Discover objects of type k8s.Namespace on " + this, engine);
        ctx.addStep((Step)step);
    }
}

