
import com.xebialabs.deployit.plugin.kubernetes.inspect.OverthereFileHelper as OverthereFileHelper
import yaml
import logging
import re
import os.path

log = logging.getLogger(__name__)

def new_instance(id, ci_type):
    return Type.valueOf(ci_type).descriptor.newInstance(id)

def replaceSpecialCharacters(value):
    return re.sub('[^A-Za-z0-9]+', '-', value)

def discoverK8sMaster(ci, ci_id, server, cert_auth, client_cert, client_key, auth_token, skip_tls_flag, kubeconfig):
    if ci:
        k8s_master = ci
        k8s_master.id = ci_id
    else:
        k8s_master = new_instance(ci_id, "k8s.Master")

    k8s_master.setProperty("apiServerURL", server)
    k8s_master.setProperty("caCert", cert_auth)
    k8s_master.setProperty("tlsCert", client_cert)
    k8s_master.setProperty("tlsPrivateKey", client_key)
    k8s_master.setProperty("token", auth_token)
    k8s_master.setProperty("kubeconfigFile", kubeconfig)


    if skip_tls:
        k8s_master.setProperty("skipTLS", True)
    print("Recording k8s master %s in repository" % str(k8s_master))

    if not ci:
        inspectionContext.discovered(k8s_master)
        inspectionContext.inspected(k8s_master)

    print "K8s Master [%s] has been discovered" % k8s_master.name

def discoverK8sNamespace(k8s_master_id, namespace):
    namespace_id = k8s_master_id + '/' + namespace
    namespace_ci = new_instance(namespace_id, "k8s.Namespace")
    namespace_ci.setProperty("namespaceName", namespace)
    print("Recording k8s namespace %s in repository" % str(namespace))
    inspectionContext.discovered(namespace_ci)
    inspectionContext.inspected(namespace_ci)
    print "K8s Namespace [%s] has been discovered" % namespace_ci.name

def resolveFileData(file_path):
    data = None
    try:
        if os.path.exists(file_path):
            with open(file_path, 'r') as file:
                data = file.read()
        else:
            print "Auth file not found"
    except Exception as e:
        print "Exception in reading auth file"
        print e.message, e.args
        data = None

    return data

kubeconfigFile = thisCi.getProperty("kubeconfigFile")
name=thisCi.name
id=thisCi.id

fileContent = None
try:
    fileContent = OverthereFileHelper.getFileContent(kubeconfigFile.file)
except:
    print "Failed to get kubeconfig file content"

if fileContent:
    config = yaml.safe_load(fileContent)
    clusters = config['clusters']
    users = config['users']
    contexts = config['contexts']
    first_context = True

    for current_context in contexts:
        context_name = current_context['name']
        cluster_name = current_context['context']['cluster']
        user_name = current_context['context']['user']

        current_cluster = None
        for cluster in clusters:
            if cluster['name'] == cluster_name:
                current_cluster = cluster
                break

        current_user = None
        for user in users:
            if user['name'] == user_name:
                current_user = user
                break

        if not current_cluster:
            print 'Cluster - %s information not found for context %s.' % (cluster_name, context_name)
            continue

        if not current_user:
            print 'User - %s information not found for context %s.'% (user_name, context_name)
            continue

        if 'server' in current_cluster['cluster']:
            server_url = current_cluster['cluster']['server']
        else:
            print 'Server information not found for context %s.' % context_name
            continue

        skip_tls = False
        if 'insecure-skip-tls-verify' in current_cluster['cluster']:
            skip_tls = current_cluster['cluster']['insecure-skip-tls-verify']

        if 'certificate-authority-data' in current_cluster['cluster']:
            cert_auth_data = current_cluster['cluster']['certificate-authority-data']
        elif 'certificate-authority' in current_cluster['cluster']:
            cert_auth_data = resolveFileData(current_cluster['cluster']['certificate-authority'])
            if not cert_auth_data:
                print 'Certificate Auth could not be resolved for context %s.' % context_name
                continue
        else:
            print 'Certificate Auth could not be resolved for context %s.' % context_name
            continue
        if 'client-certificate-data' in current_user['user']:
            client_cert_data = current_user['user']['client-certificate-data']
        elif 'client-certificate' in current_user['user']:
            client_cert_data = resolveFileData(current_user['user']['client-certificate'])
            if not client_cert_data:
                print 'Client Certificate could not be resolved for context %s user %s.' % (context_name, user_name)
                continue
        else:
            print 'Client Certificate could not be resolved for context %s user %s.' % (context_name, user_name)
            continue

        if 'client-key-data' in current_user['user']:
            client_key_data = current_user['user']['client-key-data']
        elif 'client-key' in current_user['user']:
            client_key_data = resolveFileData(current_user['user']['client-key'])
            if not client_key_data:
                print 'Client Key could not be resolved for context %s user %s.' % (context_name, user_name)
                continue
        else:
            print 'Client key could not be resolved for context %s user %s.' % (context_name, user_name)
            continue

        token = None
        if 'token' in current_user['user']:
            token = current_user['user']['token']

        if (not client_key_data or not client_cert_data) and  not token:
            print 'Client auth information could not be resolved for context %s user %s.' % (context_name, user_name)
            continue

        context_name_replaced = replaceSpecialCharacters(context_name)

        master_id = "Infrastructure/%s" % context_name_replaced
        discovery_ci = None
        if first_context:
            #Use the discovery CI to fill the first context info
            discovery_ci = thisCi
            first_context = False
        discoverK8sMaster(discovery_ci, master_id, server_url, cert_auth_data, client_cert_data, client_key_data, token, skip_tls, kubeconfigFile)

        name_space = None
        if 'namespace' in current_context['context']:
            name_space = current_context['context']['namespace']
            discoverK8sNamespace(master_id, name_space)
else:
    print "Failed to retieve kubeconfig file content"
