#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.cronjob.cronjob_helper import CronJobHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper

container_helper = ContainerHelperFactory(deployed.container).create()
PodHelper.validate_pod(deployed_pod=deployed)
CronJobHelper.validate_cronjob(deployed_cronjob=deployed)
cronjob_name = CronJobHelper().get_cronjob_name(deployed)

context.addStepWithCheckpoint(steps.jython(
    description="{0} CronJob {1} on {2}".format('Create', cronjob_name,
                                                   container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/cronjob/create_cronjob.py",
    order=deployed.createOrder
), delta)

context.addStep(steps.jython(
    description="Wait for CronJob {0} to be created".format(cronjob_name),
    script="xld/kubernetes/cronjob/wait_for_create.py",
    order=deployed.createOrder + 1
))
