#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.statefulset.statefulset_helper import StatefulSetHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper
from xld.kubernetes.service.exposedservices.service_steps_helper import ExposedServiceStepsHelper

StatefulSetHelper.enrich_app_selectors(deployed)
container_helper = ContainerHelperFactory(deployed.container).create()
PodHelper.validate_pod(deployed_pod=deployed)
statefulset_helper = StatefulSetHelper()
statefulset_helper.validate_statefulset(deployed_statefulset=deployed)

context.addStepWithCheckpoint(steps.jython(
    description="{0} StatefulSet {1} on {2}".format(
        'Create', StatefulSetHelper().get_statefulset_name(deployed),
        container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/statefulset/create_statefulset.py",
    order=deployed.createOrder
), delta)

if deployed.minimumPodCount > 0:
    context.addStepWithCheckpoint(steps.jython(
        description="Wait for StatefulSet {0} to be in running state".format(statefulset_helper.get_statefulset_name(deployed)),
        script="xld/kubernetes/statefulset/wait_for_statefulset_ready.py",
        order=deployed.createOrder + 1
    ), delta)

services = ExposedServiceStepsHelper.get_exposed_services(deployed.containers,deployed.labels,
                                                          statefulset_helper.get_statefulset_name(deployed))
ExposedServiceStepsHelper(context, steps).add_create_steps(deployed, services, delta)
