/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.kubernetes.inspect;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;

public class JythonInspectionStep
implements Step {
    private String inspectScript;
    private Map<String, Object> scriptParams;
    private String description;
    public static final String JYTHON_SCRIPT_ENGINE = "jython";

    public JythonInspectionStep(String inspectScript, Map<String, Object> scriptParams, String description) {
        this.inspectScript = inspectScript.trim();
        this.scriptParams = scriptParams;
        this.description = description;
    }

    public int getOrder() {
        return 0;
    }

    public String getDescription() {
        return this.description;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Starting python engine...");
        ScriptEngine engine = new ScriptEngineManager(Thread.currentThread().getContextClassLoader()).getEngineByName(JYTHON_SCRIPT_ENGINE);
        engine = new ScriptEngineManager().getEngineByName("python");
        if (engine == null) {
            throw new IllegalStateException("Could not find the python/jython, is it on the classpath?");
        }
        ctx.logOutput("Loading script " + this.inspectScript);
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.inspectScript);
        if (resourceAsStream == null) {
            throw new IllegalStateException("Inspection script " + this.inspectScript + " not found");
        }
        ctx.logOutput("Initializing context ");
        ScriptContext scriptContext = this.createScriptContext(ctx);
        InputStream sugarPy = Thread.currentThread().getContextClassLoader().getResourceAsStream("syntactical/sugar.py");
        if (sugarPy != null) {
            engine.eval((Reader)new InputStreamReader(sugarPy), scriptContext);
        }
        engine.eval((Reader)new InputStreamReader(resourceAsStream), scriptContext);
        ctx.logOutput("Done.");
        return StepExitCode.SUCCESS;
    }

    private ScriptContext createScriptContext(ExecutionContext ctx) {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute("inspectionContext", ctx.getInspectionContext(), 100);
        for (Map.Entry<String, Object> entry : this.scriptParams.entrySet()) {
            scriptContext.setAttribute(entry.getKey(), entry.getValue(), 100);
        }
        scriptContext.setWriter(new ConsumerWriter(ctx, false));
        scriptContext.setErrorWriter(new ConsumerWriter(ctx, true));
        return scriptContext;
    }

    private static class ConsumerWriter
    extends Writer {
        private ExecutionContext ctx;
        private boolean logToError;

        ConsumerWriter(ExecutionContext ctx, boolean logToError) {
            this.ctx = ctx;
            this.logToError = logToError;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            char[] chars = Arrays.copyOfRange(cbuf, off, off + len);
            if (this.logToError) {
                this.ctx.logError(String.valueOf(chars));
            } else {
                this.ctx.logOutput(String.valueOf(chars));
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

