#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper
from xld.kubernetes.service.exposedservices.service_steps_helper import ExposedServiceStepsHelper

container_helper = ContainerHelperFactory(previousDeployed.container).create()

context.addStepWithCheckpoint(steps.jython(
    description="Destroy Pod {0} from {1}".format(PodHelper.get_pod_name(previousDeployed), container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/pod/remove_pod.py",
    order=previousDeployed.destroyOrder
), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Wait for Pod {0} to be destroyed completely".format(PodHelper.get_pod_name(previousDeployed)),
    script="xld/kubernetes/pod/wait_for_pod_deletion.py",
    order=previousDeployed.destroyOrder
), delta)

services = ExposedServiceStepsHelper.get_exposed_services(previousDeployed.containers,previousDeployed.labels,
                                                          PodHelper.get_pod_name(previousDeployed))
ExposedServiceStepsHelper(context, steps).add_destroy_steps(previousDeployed, services, delta)
