#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from kubernetes import client
from kubernetes.client.rest import ApiException
from xld.kubernetes import KubernetesBaseClient


class KubernetesStorageClient(KubernetesBaseClient):

    API_NAME = 'storage.k8s.io'

    def __init__(self, container):
        super(KubernetesStorageClient, self).__init__(container)

    def get_storage_api(self):
        version = self.get_api_version()
        print ("[Using API Group version: {} for api: {}]".format(version, self.API_NAME))
        return self.get_version_client(version)

    def get_api_version(self):
        return self.get_preferred_version(self.API_NAME)


