import os


def create_loader():
    return Loader()


import com.xebialabs.deployit.plugin.kubernetes.BotoLoader as BotoLoader


class Loader(object):
    def __init__(self):
        self._cache = {}
        self._search_paths = []

    @property
    def search_paths(self):
        return self._search_paths

    def list_available_services(self, type_name):
        return BotoLoader.listAvailableServices()

    def determine_latest_version(self, service_name, type_name):
        return max(self.list_api_versions(service_name, type_name))

    def list_api_versions(self, service_name, type_name):
        return BotoLoader.listApiVersion(service_name, type_name)

    def load_service_model(self, service_name, type_name, api_version=None):
        if api_version is None:
            api_version = self.determine_latest_version(
                service_name, type_name)
        full_path = os.path.join(service_name, api_version, type_name)
        return self.load_data(full_path)

    def load_data(self, name):
        import json

        return json.loads(BotoLoader.loadFile(name))


# Botocore looks for the HOME variable but UNIX init.d service doesn't pass environment variables.
# The script breaks if it doesn't find the variable, thus setting it externally.

if 'HOME' not in os.environ:
    os.environ['HOME'] = os.getenv('xldeploy_home', '/')
