#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import sys

from xld.kubernetes import *
from xld.kubernetes.eks.eks_helper import EKSHelper
from xld.kubernetes.gke.gke_helper import GKEHelper
from xld.kubernetes.core_api_client import KubernetesCoreClient


print "------------------"
print "Describing Service {0}".format(thisCi.name)
print "------------------"
try:
    # AWS EKS - Get session token
    if thisCi.isEKS:
        print "Generating AWS k8s token.."
        helper = EKSHelper(thisCi.accessKey, thisCi.accessSecret, thisCi.isAssumeRole, thisCi.accountId, thisCi.roleName, thisCi.durationSeconds)
        token = helper.get_k8s_token(thisCi.clusterName, thisCi.regionName) if thisCi.regionName else helper.get_k8s_token(thisCi.clusterName)
        if token:
            thisCi.token = token
        else:
            raise RuntimeError("Cannot generate k8s token from AWS")

    # Google GKE - Get session token
    if thisCi.isGKE:
        gke_helper = GKEHelper()
        gketoken = gke_helper.get_gke_token(thisCi.clientEmail, thisCi.privateKey, thisCi.projectId)
        if gketoken:
            thisCi.token = gketoken
        else:
            raise RuntimeError("Cannot generate k8s token from GKE")

    with KubernetesCoreClient(thisCi) as client:
        service_response = client.read_namespaced_service(params.serviceName,params.namespace)
    if service_response is False:
        raise RuntimeError("Service not available or ready !")
    service_details=service_response.to_dict()
    print("Name  : {}".format(service_details['metadata']['name']))
    print("Namespace  : {}". format(service_details['metadata']['namespace']))
    print("Annotations  : {}". format(service_details['metadata']['annotations']))
    print("External Traffic Policy  : {}". format(service_details['spec']['external_traffic_policy']))
    print("Selector  : {}". format(service_details['spec']['selector']))
    print("Type of Service  : {}". format(service_details['spec']['type']))
    print("IP  : {}". format(service_details['spec']['cluster_ip']))
    print("Session_Affinity  : {}". format(service_details['spec']['session_affinity']))
    print("Ports  : {}". format(service_details['spec']['ports']))
    print("Labels  : {}". format(service_details['metadata']['labels']))
    ingress = service_response.status.load_balancer.ingress
    if ingress:
        print("LoadBalancer Ingress  : {}".format(service_details['status']))
except Exception as e:
    print "Describing service failed. {0}".format(str(e))
    sys.exit(1)


