/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.kubernetes;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.SecurityUtils;
import com.google.api.services.compute.Compute;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GoogleCloudCompute {
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/cloud-platform");
    private static final String APPLICATION_NAME = "XebiaLabs/1.0";
    private final HttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
    private final GoogleCredential credential;
    private final Compute compute;
    private final String project;

    public GoogleCloudCompute(String client_email, String private_key, String projectId) throws IOException, GeneralSecurityException {
        PrivateKey privateKey = GoogleCloudCompute.privateKeyFromPkcs8(private_key);
        GoogleCredential.Builder credentialBuilder = new GoogleCredential.Builder().setTransport(this.httpTransport).setJsonFactory(JSON_FACTORY).setServiceAccountId(client_email).setServiceAccountScopes(Collections.emptyList()).setServiceAccountPrivateKey(privateKey).setServiceAccountProjectId(projectId);
        this.credential = credentialBuilder.build().createScoped(SCOPES);
        this.compute = new Compute.Builder(this.httpTransport, JSON_FACTORY, null).setApplicationName(APPLICATION_NAME).setHttpRequestInitializer((HttpRequestInitializer)this.credential).build();
        this.project = projectId;
    }

    public GoogleCloudCompute(String accessToken, String projectIdf, Boolean rfe) throws IOException, GeneralSecurityException {
        GoogleCredential.Builder credentialBuilderNew = new GoogleCredential.Builder().setTransport(this.httpTransport).setJsonFactory(JSON_FACTORY).setClientSecrets("client_id", "client_secret");
        this.credential = credentialBuilderNew.build().createScoped(SCOPES);
        this.credential.setAccessToken(accessToken);
        this.compute = new Compute.Builder(this.httpTransport, JSON_FACTORY, null).setApplicationName(APPLICATION_NAME).setHttpRequestInitializer((HttpRequestInitializer)this.credential).build();
        this.project = projectIdf;
    }

    public String generateToken() throws IOException {
        this.credential.refreshToken();
        return this.credential.getAccessToken();
    }

    private static PrivateKey privateKeyFromPkcs8(String privateKeyPem) throws IOException {
        StringReader reader = new StringReader(privateKeyPem);
        PemReader.Section section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        GeneralSecurityException unexpectedException = null;
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException exception) {
            unexpectedException = exception;
        }
        catch (InvalidKeySpecException exception) {
            unexpectedException = exception;
        }
        throw new RuntimeException("Unexpected exception reading PKCS data", unexpectedException);
    }
}

