#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from xld.kubernetes.ingress.helper import IngressHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

container_helper = ContainerHelperFactory(previousDeployed.container).create()
context.addStepWithCheckpoint(steps.jython(
    description="Delete ingress {0} from {1}".format(IngressHelper.get_name(previousDeployed),
                                                               container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/ingress/delete_ingress.py",
    order=previousDeployed.destroyOrder
), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Wait for ingress {0} to be deleted completely.".format(
        IngressHelper.get_name(previousDeployed)),
    script="xld/kubernetes/ingress/wait_for_deletion.py",
    order=previousDeployed.destroyOrder + 1
), delta)
