#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.commons.common_utils import CommonUtils
from xld.kubernetes.core_api_client import KubernetesCoreClient
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.config_map.helper import ConfigMapHelper
from kubernetes import client as k8s_client


class ConfigMapService(object):

    def create(self, deployed):
        container_helper = self.__create_container_helper(deployed.container)
        with self.__create_client(deployed.container.container) as client:
            request_config_map = ConfigMapHelper.read_config_map(deployed)
            CommonUtils.print_request_dump(deployed.container.container, request_config_map,
                                           CommonUtils.get_kind(self), client.get_api_version())
            response_config_map = client.core_api.create_namespaced_config_map(
                namespace=container_helper.get_container_name(deployed.container),
                body=request_config_map)
        CommonUtils.print_response_dump(deployed.container.container, response_config_map)

    def modify(self, deployed):
        container_helper = self.__create_container_helper(deployed.container)
        with self.__create_client(deployed.container.container) as client:
            request_config_map = ConfigMapHelper.read_config_map(deployed)
            CommonUtils.print_request_dump(deployed.container.container, request_config_map,
                                           CommonUtils.get_kind(self), client.get_api_version())

            response_config_map = client.core_api.replace_namespaced_config_map(
                name=ConfigMapHelper.get_config_map_name(deployed),
                namespace=container_helper.get_container_name(deployed.container),
                body=request_config_map)
        CommonUtils.print_response_dump(deployed.container.container, response_config_map)

    def destroy(self, deployed):
        container_helper = self.__create_container_helper(deployed.container)
        with self.__create_client(deployed.container.container) as client:
            client.core_api.delete_namespaced_config_map(name=ConfigMapHelper.get_config_map_name(deployed),
                                                               namespace=container_helper.get_container_name(deployed.container),
                                                               body=k8s_client.V1DeleteOptions())

    def is_present(self, deployed):
        container_helper = self.__create_container_helper(deployed.container)
        with self.__create_client(deployed.container.container) as client:
            response = client.core_api.list_namespaced_config_map(
                namespace=container_helper.get_container_name(deployed.container),
                field_selector="metadata.name={}".format(ConfigMapHelper.get_config_map_name(deployed)))
        if len(response.items) > 0:
            return True
        return False

    @staticmethod
    def __create_client(container):
        return KubernetesCoreClient(container)

    @staticmethod
    def __create_container_helper(container):
        return ContainerHelperFactory(container).create()
